
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_CannedComment : BaseTest 
	{

		private DataTable _dtCannedComment;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtCannedComment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetCannedComments_Pass()
		{		
			DataTable dtTest = DAL.CannedComment.GetCannedComments(UnitTestConfig.TestDivisionCode);
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentGuid), TABLES.CannedComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentCategoryCode), TABLES.CannedComment.CannedCommentCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.SortColumn), TABLES.CannedComment.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.DivisionCode), TABLES.CannedComment.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RecordStatusCode), TABLES.CannedComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateDate), TABLES.CannedComment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateUser), TABLES.CannedComment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CreationDate), ARTIFICIAL.CreationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CreationUser), ARTIFICIAL.CreationUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ExceptionPatientTestInactivated.InactivationDate), TABLES.ExceptionPatientTestInactivated.InactivationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.InactivationUser), ARTIFICIAL.InactivationUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RowVersion), TABLES.CannedComment.RowVersion);
		}

		[Test]
		public void GetCannedComments_Fail()
		{		
			DataTable dtTest = DAL.CannedComment.GetCannedComments(string.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetCannedComments_String_String_Pass()
		{			
			string category = this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentCategoryCode].ToString();
			DataTable dtTest = DAL.CannedComment.GetCannedComments(UnitTestConfig.TestDivisionCode, category);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentGuid), TABLES.CannedComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentCategoryCode), TABLES.CannedComment.CannedCommentCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.SortColumn), TABLES.CannedComment.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.DivisionCode), TABLES.CannedComment.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RecordStatusCode), TABLES.CannedComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateUser), TABLES.CannedComment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RowVersion), TABLES.CannedComment.RowVersion);
		}
		
		[Test]
		public void GetCannedComments_String_String_Fail()
		{		
			DataTable dtTest = DAL.CannedComment.GetCannedComments(string.Empty, string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetCannedComment_Pass()
		{			
			System.Guid commentGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];
			DataTable dtTest = DAL.CannedComment.GetCannedComment(commentGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentGuid), TABLES.CannedComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentCategoryCode), TABLES.CannedComment.CannedCommentCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.SortColumn), TABLES.CannedComment.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.DivisionCode), TABLES.CannedComment.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RecordStatusCode), TABLES.CannedComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateDate), TABLES.CannedComment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateUser), TABLES.CannedComment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RowVersion), TABLES.CannedComment.RowVersion);
		}

		[Test]
		public void GetCannedComment_Fail()
		{			
			DataTable dtTest = DAL.CannedComment.GetCannedComment(System.Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetCannedCommentCategories_Pass()
		{			
			DataTable dtTest = CannedComment.GetCannedCommentCategories();
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedCommentCategory.CannedCommentCategoryCode), TABLES.CannedCommentCategory.CannedCommentCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedCommentCategory.CannedCommentCategoryText), TABLES.CannedCommentCategory.CannedCommentCategoryText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedCommentCategory.LockingGuid), TABLES.CannedCommentCategory.LockingGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCannedCommentCategories_Fail()
		{			
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Save_Pass()
		{			
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Save_Fail()
		{	
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}

		[Test]
		public void GetEmptyCannedCommentTableSchema_Pass()
		{
			DataTable dtTest = DAL.CannedComment.GetEmptyCannedCommentTableSchema(true);
	
			Assert.AreEqual(TABLES.CannedComment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentGuid), TABLES.CannedComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.SortColumn), TABLES.CannedComment.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateFunctionId), TABLES.CannedComment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RecordStatusCode), TABLES.CannedComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RowVersion), TABLES.CannedComment.RowVersion);
		}

		[Test]
		public void GetEmptyCannedCommentTableSchema_Fail()
		{			
			DataTable dtTest = DAL.CannedComment.GetEmptyCannedCommentTableSchema(false);
	
			Assert.AreEqual(TABLES.CannedComment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentGuid), TABLES.CannedComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.SortColumn), TABLES.CannedComment.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.LastUpdateFunctionId), TABLES.CannedComment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.RecordStatusCode), TABLES.CannedComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentCategoryCode), TABLES.CannedComment.CannedCommentCategoryCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.DivisionCode), TABLES.CannedComment.DivisionCode);
		}

        
	}
}
#endif
